import sys
import datetime
import xtrain

t1 = datetime.datetime.today()
print('処理開始 ' + str(t1.month) + '月' + str(t1.day) + '日 ' + str(t1.hour) + ':' + str(t1.minute) + ':' + str(t1.second) + '.' + str(t1.microsecond))

book_path = 'PythonX-TRAiNサンプル'

#
# Excelブックオープン
#
book = xtrain.AXLS_open_book()
if not book:
	print('AXLS_open_book() ERROR')
	sys.exit()

#
# ブック名指定
#
argument = 'BOOK=' + book_path + ' SHEET=SAMPLE'

rtn = xtrain.AXLS_put_values(book, argument)
if rtn != 0:
	error_code = xtrain.AXLS_error_code(book)
	error_mesg = xtrain.AXLS_error_mesg(book)
	print('AXLS_put_values() ERROR code=' + str(error_code) + ' message=' + error_mesg)
	xtrain.AXLS_scrap_book(book)
	sys.exit()

#
# 列幅設定
#
argument = 'B.幅=20 C.幅=20 D.幅=20 E.幅=20'

rtn = xtrain.AXLS_put_values(book, argument)
if rtn != 0:
	error_code = xtrain.AXLS_error_code(book)
	error_mesg = xtrain.AXLS_error_mesg(book)
	print('AXLS_put_values() ERROR code=' + str(error_code) + ' message=' + error_mesg)
	xtrain.AXLS_scrap_book(book)
	sys.exit()

now_date= str(t1.year) + '/' + str(t1.month) + '/' + str(t1.day)
line_ct = 0
max_row = 1000

#
# 行数繰り返し
#
for row in range(1,max_row):

	#
	# A～E列に数値、文字、日付を設定
	#
	cell1 = xtrain.AXLS_cell_name(row, 1)
	cell2 = xtrain.AXLS_cell_name(row, 2)
	cell3 = xtrain.AXLS_cell_name(row, 3)
	cell4 = xtrain.AXLS_cell_name(row, 4)
	cell5 = xtrain.AXLS_cell_name(row, 5)
	line_ct = line_ct + 1

	argument = cell1 + '=' + str(row) + ' ' + cell2 + '=日本語文字列' + str(row) + ' ' + cell2 + '.フォント.色=赤 ' + cell3 + '=' + now_date + ' ' + cell3 + '.書式=和暦 ' + cell4 + '=ABCDEFG ' + cell4 + '.フォント.名=\"Arial Black\" ' + cell5 + '=12345 ' + cell5 + '.書式=漢数字'

	rtn = xtrain.AXLS_put_values(book, argument)
	if rtn != 0:
		error_code = xtrain.AXLS_error_code(book)
		error_mesg = xtrain.AXLS_error_mesg(book)
		print('AXLS_put_values() ERROR code=' + str(error_code) + ' message=' + error_mesg)
		xtrain.AXLS_scrap_book(book)
		sys.exit()

	#
	# 偶数行を塗りつぶす
	#
	if line_ct % 2 == 0:

		range = xtrain.AXLS_cell_range(row, 1, row, 5)
		argument = range + '.塗りつぶし.色=#CCCCCC'

		rtn = xtrain.AXLS_put_values(book, argument)
		if rtn != 0:
			error_code = xtrain.AXLS_error_code(book)
			error_mesg = xtrain.AXLS_error_mesg(book)
			print('AXLS_put_values() ERROR code=' + str(error_code) + ' message=' + error_mesg)
			xtrain.AXLS_scrap_book(book)
			sys.exit()
#
# 表全体に罫線を付ける
#
range = xtrain.AXLS_cell_range(1, 1, max_row, 5)
argument = range + ".罫線=実線";

rtn = xtrain.AXLS_put_values(book, argument)
if rtn != 0:
	error_code = xtrain.AXLS_error_code(book)
	error_mesg = xtrain.AXLS_error_mesg(book)
	print('AXLS_put_values() ERROR code=' + str(error_code) + ' message=' + error_mesg)
	xtrain.AXLS_scrap_book(book)
	sys.exit()

#
# Excelブック保存
#
rtn = xtrain.AXLS_save_book(book)
if rtn != 0:
	error_code = xtrain.AXLS_error_code(book)
	error_mesg = xtrain.AXLS_error_mesg(book)
	print('AXLS_save_book() ERROR code=' + str(error_code) + ' message=' + error_mesg)
	xtrain.AXLS_scrap_book(book)
	sys.exit()

print('Excelブック ' + book_path + ' 作成完了')
t1 = datetime.datetime.today()
print('処理終了 ' + str(t1.month) + '月' + str(t1.day) + '日 ' + str(t1.hour) + ':' + str(t1.minute) + ':' + str(t1.second) + '.' + str(t1.microsecond))
